﻿using System;
using System.Collections.Generic;
using Microsoft.SharePoint;

class Program
{
   static void Main(string[] args)
   {
      using (SPSite site = new SPSite("http://contoso.de"))
      {
         using (SPWeb web = site.OpenWeb())
         {
            List<Guid> lookupFieldsGuids = new List<Guid>();
            SPList listOrders = web.Lists.TryGetList("Bestellungen");

            // Hole die Liste sämtlicher Felder
            SPFieldCollection fields = listOrders.Fields;

            // Durchlaufe alle Felder und prüfe, ob es ein Lookup-Feld ist
            foreach (SPField field in listOrders.Fields)
            {
               // Prüfe, ob die Spalte ein Lookup-Feld ist
               if (field is SPFieldLookup)
               {
                  SPFieldLookup lookupField = field as SPFieldLookup;

                  // Prüfe, ob die Lookup-Spalte ein Mehrfachauswahl-Feld ist
                  // und es sich nicht um eine versteckte Spalte handelt
                  if (!lookupField.AllowMultipleValues && !field.Hidden)
                     lookupFieldsGuids.Add(field.Id);
               }
            }

            // Listenelemente ausgeben
            SPListItemCollection allItems = listOrders.Items;

            foreach (SPListItem item in allItems)
            {
               Console.WriteLine("{0} ({1})", item.Title, item.ID);

               // Felder iterieren
               foreach (Guid id in lookupFieldsGuids)
               {
                  string lookupValueAsString = item[id] != null ?
                     item[id].ToString() : String.Empty;

                  SPFieldLookupValue lookupValue =
                     new SPFieldLookupValue(lookupValueAsString);

                  Console.WriteLine("> {0}: {1}",
                     listOrders.Fields[id].InternalName.PadRight(20),
                     lookupValue.LookupValue != null ?
                     lookupValue.LookupValue : String.Empty);
               }
               Console.WriteLine();
            }
         }
      }
   }
}